
#define DO_FUNC_ADDRS
#define DO_FUNC_OPS
#define DO_FUNC_RW
#define DO_GLOBREGS
//#define DO_FUNC_ADC

#ifdef __GNUC__
#define ASMREG(x) asm(#x)
#define ASMREGX(x)
#define CASE(x) case x: asm("@ OP " #x);
#define BREAK break;
#else
#define ASMREG(x)
#define ASMREGX(x)
#define CASE(x) case x:
#define BREAK break;
#define register
#endif

typedef unsigned char boolean;
typedef unsigned char byte;
typedef unsigned short word;
typedef struct
{
	byte A,X,Y,P,S;
	word PPC;
	int clock;
	byte* mem;
}  T6502State;

typedef T6502State T6502Emulation;

int read6502(T6502Emulation* context, int x);
void write6502(T6502Emulation* context, int x, int y);

#ifdef DO_GLOBREGS

register int P ASMREG(r4);
register T6502Emulation* emu ASMREG(r5);
register word PC ASMREG(r6);
register byte A ASMREG(r7);
register int cycles ASMREG(r8);
register byte* mem ASMREG(r9);

#endif

#ifdef __GNUC__

#define SAVE_REGS asm("stmfd sp!,{r4,r5,r6,r7,r8,r9}");
#define RESTORE_REGS asm("ldmfd sp!,{r4,r5,r6,r7,r8,r9}");

#else

#define SAVE_REGS
#define RESTORE_REGS

#endif

typedef unsigned char BYTE;
typedef unsigned short WORD;
typedef unsigned int DWORD;
typedef unsigned char BOOL;
typedef WORD* LPWORD;


#define  AF_SIGN       0x80
#define  AF_OVERFLOW   0x40
#define  AF_RESERVED   0x20
#define  AF_BREAK      0x10
#define  AF_DECIMAL    0x08
#define  AF_INTERRUPT  0x04
#define  AF_ZERO       0x02
#define  AF_CARRY      0x01

#define GETF_C (P & AF_CARRY)
#define GETF_N (P & AF_SIGN)
#define GETF_V (P & AF_OVERFLOW)
#define GETF_Z (P & AF_ZERO)

#define GET_P (P)

#define SETF_C(x) P = (x) ? (P|AF_CARRY) : (P&~AF_CARRY);
#define SETF_N(x) P = (x) ? (P|AF_SIGN) : (P&~AF_SIGN);
#define SETF_V(x) P = (x) ? (P|AF_OVERFLOW) : (P&~AF_OVERFLOW);
#define SETF_Z(x) P = (x) ? (P|AF_ZERO) : (P&~AF_ZERO);

#define  SHORTOPCODES  22
#define  BENCHOPCODES  33

#define apple2e 0

/****************************************************************************
*
*  GENERAL PURPOSE MACROS
*
***/

#define HACK 0

#define TOWORD(x) ((x) & 0xffff)

#define TOBYTE(x) ((x) & 0xff)

#define CYC(a)   cycles -= a;

#define CMOS      if (!apple2e) {                                           \
                    CYC(-1)                                               \
                    BREAK                                                  \
                  }

#define POP      (mem[S >= 0x1FF ? (S = 0x100) : ++S])

#define POPW	 ((POP) + (((int)POP)<<8))

#define PUSH(a)  mem[S--] = (a);                                    \
                 if (S < 0x100)                                       \
                   S = 0x1FF;

#define READ		READB(addr)

#define READZB(a)    ((int)mem[a])

#define READB(a)    (read6502(emu,a))

#define READBOP(a)	((int)mem[a])

#define READW(a)    (READB(a) + (((int)READB((a)+1))<<8))

#define SETNZ(a) { \
					P = (P & ~(AF_SIGN|AF_ZERO)) | ((a) & AF_SIGN);	\
					if (!(a&0xff)) P |= AF_ZERO; \
                 }

#define SETZ(a)  SETF_Z(!(a&0xff))

#define TOBCD(a) (((((a)/10) % 10) << 4) | ((a) % 10))

#define TOBIN(a) (((a) >> 4)*10 + ((a) & 0x0F))

#define WRITE(a) { write6502(emu,addr,a); }

#define WRITEZB(a) { mem[addr] = a; }

#define ADDPC(x) (PC+=(x))

#define FETCH  (READBOP(PC++))

#define BRANCH(cond) if (cond) { PC+=addr; CYC(1) }

#ifdef DO_FUNC_RW

int f_read(int a)
{
	if ((a & 0xf000) == 0xc000) {
		int x;
		SAVE_REGS
		x = read6502(emu,a);
		RESTORE_REGS
		return x;
	} else {
		return mem[a];
	}
}
#undef READB
//#define READB(a) ( ((a & 0xf000) == 0xc000) ? f_read(a) : mem[a] )
#define READB(a) (f_read(a))

void f_write(int a, int v)
{
	SAVE_REGS
	write6502(emu,a,v);
	RESTORE_REGS
}
#undef WRITE
#define WRITE(a) f_write(addr, a);

#endif // DO_FUNC_RW

/****************************************************************************
*
*  ADDRESSING MODE MACROS
*
***/

#define ABS      addr = FETCH; addr |= (FETCH<<8);

#define ABSIINDX addr = *(LPWORD)((*(LPWORD)(mem+PC))+(WORD)X);  PC += 2; //** NOT RIGHT

#define ABSX     ABS  addr = TOWORD(addr + X);

#define ABSY     ABS  addr = TOWORD(addr + Y);

#define IABS     ABS \
				 addr = READW(addr);
				 //addr = READ(addr) + (READ( ((addr+1) & 0xff) | (addr & 0xff00))) << 8;

#define IMM      addr = PC; PC++;

#define INDX     ZPGX \
                 addr = READZB(addr) + (READZB(addr+1) << 8);

#define INDY     ZPG \
				 addr = TOWORD( Y + READZB(addr) + (READZB(addr+1) << 8) );

#define IZPG     ZPG \
				 addr = TOWORD( READZB(addr) + (READZB(addr+1) << 8) );

#define REL      addr = (signed char)FETCH;

#define ZPG      addr = FETCH;

#define ZPGX     addr = TOBYTE(FETCH + X);

#define ZPGY     addr = TOBYTE(FETCH + Y);

#ifdef DO_FUNC_ADDRS

#define DEF_ADDR(x) \
	static int f_##x() \
	{ \
		int addr; \
		x \
		return addr; \
	}
#define DEF_CALL(x,y) addr=f_##x();
#define DEF_ADDRX(x) \
	static int f_##x(int X) \
	{ \
		int addr; \
		x \
		return addr; \
	}
#define DEF_CALLX(x,y) addr=f_##x(X);
#define DEF_ADDRY(x) \
	static int f_##x(int Y) \
	{ \
		int addr; \
		x \
		return addr; \
	}
#define DEF_CALLY(x,y) addr=f_##x(Y);

DEF_ADDR(ABS)
#undef ABS
#define ABS DEF_CALL(ABS,2)
DEF_ADDRX(ABSX)
#undef ABSX
#define ABSX DEF_CALLX(ABSX,2)
DEF_ADDRY(ABSY)
#undef ABSY
#define ABSY DEF_CALLY(ABSY,2)
DEF_ADDR(IABS)
#undef IABS
#define IABS DEF_CALL(IABS,2)
DEF_ADDRX(INDX)
#undef INDX
#define INDX DEF_CALLX(INDX,1)
DEF_ADDRY(INDY)
#undef INDY
#define INDY DEF_CALLY(INDY,1)
DEF_ADDR(ZPG)
#undef ZPG
#define ZPG DEF_CALL(ZPG,1)
DEF_ADDRX(ZPGX)
#undef ZPGX
#define ZPGX DEF_CALLX(ZPGX,1)
DEF_ADDRY(ZPGY)
#undef ZPGY
#define ZPGY DEF_CALLY(ZPGY,1)
DEF_ADDR(IZPG)
#undef IZPG
#define IZPG DEF_CALL(IZPG,1)

#endif // DO_FUNC_ADDRS

/****************************************************************************
*
* TRUCTION MACROS
*
***/


#define ADC      temp = READ;                                               \
                 if (P & AF_DECIMAL) {                                \
                   val    = TOBIN(A)+TOBIN(temp)+(P & AF_CARRY);         \
                   SETF_C(val > 99);                                     \
                   A = TOBCD(val);                                     \
                   if (apple2e)                                             \
                     SETNZ(A);                                         \
                 }                                                          \
                 else {                                                     \
                   val    = A+temp+(P & AF_CARRY);                       \
                   SETF_C(val > 0xFF);                                   \
                   SETF_V(((A & 0x80) == (temp & 0x80)) &&          \
                             ((A & 0x80) != (val & 0x80)));            \
                   A = val & 0xFF;                                     \
                   SETNZ(A);                                           \
                 }

#define SBC      temp = READ;                                               \
                 if (P & AF_DECIMAL) {                                \
                   val    = TOBIN(A)-TOBIN(temp)-!GETF_C;               \
                   SETF_C(val < 0x8000);                                 \
                   A = TOBCD(val);                                     \
                   if (apple2e)                                             \
                     SETNZ(A);                                         \
                 }                                                          \
                 else {                                                     \
                   val    = A-temp-!GETF_C;                             \
                   SETF_C(val < 0x8000);                                 \
                   SETF_V(((A & 0x80) != (temp & 0x80)) &&          \
                             ((A & 0x80) != (val & 0x80)));            \
                   A = val & 0xFF;                                     \
                   SETNZ(A);                                           \
                 }                 

#define AND      A &= READ;                                            \
                 SETNZ(A)

#define ASL      ival   = READ << 1;                                         \
                 SETF_C(ival > 0xFF);                                      \
                 SETNZ(ival)                                                 \
                 WRITE(ival)

#define ASLA     ival   = A << 1;                                       \
                 SETF_C(ival > 0xFF);                                      \
                 SETNZ(ival)                                                 \
				 A = (BYTE)ival;

#define BCC      BRANCH(!GETF_C)

#define BCS      BRANCH(GETF_C)

#define BEQ      BRANCH(GETF_Z)

#define BIT      ival   = READ;                                              \
                 SETF_Z(!(A & ival));                                   \
                 SETF_N(ival & 0x80);                                        \
                 SETF_V(ival & 0x40);

#define BITI     SETF_Z(!(A & READ));

#define BMI      BRANCH(GETF_N)

#define BNE      BRANCH(!GETF_Z)

#define BPL      BRANCH(!GETF_N)

#define BRA      BRANCH(1)

#define BRK      PUSH(PC >> 8)                                         \
                 PUSH(PC & 0xFF)                                       \
                 P |= AF_BREAK;                                       \
                 PUSH(GET_P)                                              \
                 P |= AF_INTERRUPT;                                   \
                 PC = READW(0xFFFE);

#define BVC      BRANCH(!GETF_V)

#define BVS      BRANCH(GETF_V)

#define CLC      SETF_C(0);

#define CLD      P &= ~AF_DECIMAL;

#define CLI      P &= ~AF_INTERRUPT;

#define CLV      SETF_V(0);

#define CMP      ival   = READ;                                              \
                 SETF_C(A >= ival);                                   \
                 ival   = A-ival;                                        \
                 SETNZ(ival)

#define CPX      ival   = READ;                                              \
                 SETF_C(X >= ival);                                   \
                 ival   = X-ival;                                        \
                 SETNZ(ival)

#define CPY      ival   = READ;                                              \
                 SETF_C(Y >= ival);                                   \
                 ival   = Y-ival;                                        \
                 SETNZ(ival)

#define DEA      --A;                                                  \
                 SETNZ(A)

#define DEC      ival = READ-1;                                              \
                 SETNZ(ival)                                                 \
                 WRITE(ival)

#define DEX      X=(X-1)&0xff;                                                  \
                 SETNZ(X)

#define DEY      Y=(Y-1)&0xff;                                                  \
                 SETNZ(Y)

#define EOR      A ^= READ;                                            \
                 SETNZ(A)

#define INA      ++A;                                                  \
                 SETNZ(A)

#define INC      ival = READ+1;                                              \
                 SETNZ(ival)                                                 \
                 WRITE(ival)

#define INX      X=(X+1)&0xff;                                                  \
                 SETNZ(X)

#define INY      Y=(Y+1)&0xff;                                                  \
                 SETNZ(Y)

#define JMP      PC = addr;

#define JSR      --PC;                                                 \
                 PUSH(PC >> 8)                                         \
                 PUSH(PC & 0xFF)                                       \
                 PC = addr;

#define LDA      A = READ;                                             \
                 SETNZ(A)

#define LDX      X = READ;                                             \
                 SETNZ(X)

#define LDY      Y = READ;                                             \
                 SETNZ(Y)

#define LSR      ival   = READ;                                              \
                 SETF_C(ival & 1);                                         \
                 SETF_N(0);                                                 \
                 ival >>= 1;                                                 \
                 SETZ(ival);                                                  \
                 WRITE(ival)

#define LSRA     SETF_C(A & 1);                                      \
                 SETF_N(0);                                                 \
                 A >>= 1;                                              \
                 SETZ(A)

#define NOP

#define ORA      A |= READ;                                            \
                 SETNZ(A)

#define PHA      PUSH(A)

#define PHP      P |= AF_RESERVED;                                    \
                 PUSH(GET_P)

#define PHX      PUSH(X)

#define PHY      PUSH(Y)

#define PLA      A = POP;                                              \
                 SETNZ(A)

#define PLP      P = POP;                                             

#define PLX      X = POP;                                              \
                 SETNZ(X)

#define PLY      Y = POP;                                              \
                 SETNZ(Y)

#define ROL      ival   = (READ << 1) | GETF_C;                        \
                 SETF_C(ival > 0xFF);                                      \
                 SETNZ(ival)                                                 \
                 WRITE(ival)

#define ROLA     ival    = (((int)A) << 1) | GETF_C;             \
                 SETF_C(ival > 0xFF);                                     \
                 A = ival & 0xFF;                                       \
                 SETNZ(A);

#define ROR      temp  = READ;                                              \
                 ival   = (temp >> 1) | (GETF_C ? 0x80 : 0);                  \
                 SETF_C(temp & 1);                                          \
                 SETNZ(ival)                                                 \
                 WRITE(ival)

#define RORA     ival    = (((int)A) >> 1) | (GETF_C ? 0x80 : 0);       \
                 SETF_C(A & 1);                                       \
                 A = ival & 0xFF;                                       \
                 SETNZ(A)

#define RTI      P = POP;                                             \
                 PC = POPW;                                             

#define RTS      PC = POPW;                                             \
                 PC++;

#define SEC      SETF_C(1);

#define SED      P |= AF_DECIMAL;

#define SEI      P |= AF_INTERRUPT;

#define STA      WRITE(A)

#define STX      WRITE(X)

#define STY      WRITE(Y)

#define STZ      WRITE(0)

#define TAX      X = A;                                           \
                 SETNZ(X)

#define TAY      Y = A;                                           \
                 SETNZ(Y)

#define TRB      val   = READ;                                              \
                 SETF_Z(!(A & val));                                   \
                 val  &= ~A;                                           \
                 WRITE(val)

#define TSB      val   = READ;                                              \
                 SETF_Z(!(A & val));                                   \
                 val   |= A;                                           \
                 WRITE(val)

#define TSX      X = S & 0xFF;                                   \
                 SETNZ(X)

#define TXA      A = X;                                           \
                 SETNZ(A)

#define TXS      S = 0x100 | X;

#define TYA      A = Y;                                           \
                 SETNZ(A)

#define INVALID1

#define INVALID2 if (apple2e) PC++;

#define INVALID3 if (apple2e) PC+=2;

//
// NOW, THE OPERAND FUNCTIONS
//

#ifdef DO_FUNC_OPS

// and some addressing modes

static void f_SETNZ(int a) 
{
	P = (P & ~(AF_SIGN|AF_ZERO)) | ((a) & AF_SIGN);
	if ((a & 0xff) == 0)
		P |= AF_ZERO;
}
#undef SETNZ
#define SETNZ(a) f_SETNZ(a);

static int f_TOBIN(int a)
{
	return TOBIN(a);
}
#undef TOBIN
#define TOBIN(a) f_TOBIN(a)

static int f_TOBCD(int a)
{
	return TOBCD(a);
}
#undef TOBCD
#define TOBCD(a) f_TOBCD(a)

#ifdef DO_FUNC_ADC

static void f_ADCdec(int temp)
{
	int val = TOBIN(A)+TOBIN(temp)+(P & AF_CARRY);         
	SETF_C(val > 99);                                     
	A = TOBCD(val);                                     
	if (apple2e)                                             
		SETNZ(A);                                         
}
static void f_ADCbin(int temp)
{
	int val = A+temp+(P & AF_CARRY);
	SETF_C(val > 0xFF);                                   
	SETF_V(((A & 0x80) == (temp & 0x80)) &&          
		((A & 0x80) != (val & 0x80)));            
	A = val & 0xFF;                                     
	SETNZ(A);                                           
}
#undef ADC
#define ADC if (P & AF_DECIMAL) f_ADCdec(READ); else f_ADCbin(READ);

static void f_SBCdec(int temp)
{
	int val    = TOBIN(A)-TOBIN(temp)-(GETF_C^1);               
	SETF_C(val >= 0);                                 
	A = TOBCD(val);                                     
	if (apple2e)                                             
		SETNZ(A);                                         
}                                                          
static void f_SBCbin(int temp)
{                                                     
	int val    = A-temp-(GETF_C^1);                             
	SETF_C(val >= 0);                                 
	SETF_V(((A & 0x80) != (temp & 0x80)) &&          
		((A & 0x80) != (val & 0x80)));            
	A = val & 0xFF;                                     
	SETNZ(A);                                           
}
#undef SBC
#define SBC if (P & AF_DECIMAL) f_SBCdec(READ); else f_SBCbin(READ);

#endif

static int f_ASL(int val)
{
	val = val << 1;
	SETF_C(val > 0xff);
	SETNZ(val);
	return val;
}
#undef ASL
#define ASL WRITE(f_ASL(READ));

static int f_LSR(int val)
{
	SETF_C(val & 1);                                         
	SETF_N(0);                                                 
	val >>= 1;                                                 
	SETZ(val);                                                  
	return val;
}
#undef LSR
#define LSR WRITE(f_LSR(READ));

static int f_ROL(int val)
{
	val   = (val << 1) | GETF_C;                        
	SETF_C(val > 0xFF);                                      
	SETNZ(val)                                         
	return val;
}
#undef ROL
#define ROL WRITE(f_ROL(READ));

static int f_ROR(int val)
{
	int temp = val;
	val   = (temp >> 1) | (GETF_C<<7);
	SETF_C(temp & 1);                                          
	SETNZ(val)                                                
	return val;
}
#undef ROR
#define ROR WRITE(f_ROR(READ));

static void f_BIT(int val)
{
    if ((val & A) != 0) P &= 0xfd; else P |= 0x02;
	P = (P & 0x3f) | (val & 0xc0);
}
#undef BIT
#define BIT f_BIT(READ);

static void f_CMP(int val, int a)
{
	SETF_C(a >= val);                                   
	val   = a-val;                                        
	SETNZ(val)
}
#undef CMP
#define CMP f_CMP(READ, A);
#undef CPX
#define CPX f_CMP(READ, X);
#undef CPY
#define CPY f_CMP(READ, Y);

#endif // DO_FUNC_OPS

/****************************************************************************
*
*  OPCODE TABLE
*
***/

//===========================================================================

#define register

static void execute6502_x(T6502State* state,
				 void* context,
				 int totalcycles)
{
#ifndef DO_GLOBREGS
	register int P;
	register T6502Emulation* emu;
	register unsigned short PC;
	register unsigned char A;
	register int cycles;
	register byte* mem;
#endif
    int addr;
	int S;
	int ival;
	WORD val;
	byte X;
	byte Y;
#ifndef DO_FUNC_ADC
	register int temp;
#endif

	emu = context;
	A = state->A;
	X = state->X;
	Y = state->Y;
	S = ((int)state->S) | 0x100;
	P = state->P;
	PC = state->PPC;
	cycles = totalcycles;
	mem = state->mem;

  while (cycles > 0) {
    switch (FETCH) {
      CASE(0x01)       INDX ORA      CYC(6)  BREAK
      CASE(0x08)       PHP           CYC(3)  BREAK
      CASE(0x09)       IMM ORA       CYC(2)  BREAK
      CASE(0x0A)       ASLA          CYC(2)  BREAK
      CASE(0x0D)       ABS ORA       CYC(4)  BREAK
      CASE(0x0E)       ABS ASL       CYC(6)  BREAK
      CASE(0x10)       REL BPL       CYC(3)  BREAK
      CASE(0x11)       INDY ORA      CYC(5)  BREAK
      CASE(0x18)       CLC           CYC(2)  BREAK
      CASE(0x19)       ABSY ORA      CYC(4)  BREAK
      CASE(0x1D)       ABSX ORA      CYC(4)  BREAK
      CASE(0x1E)       ABSX ASL      CYC(6)  BREAK
      CASE(0x20)       ABS JSR       CYC(6)  BREAK
      CASE(0x21)       INDX AND      CYC(6)  BREAK
      CASE(0x28)       PLP           CYC(4)  BREAK
      CASE(0x29)       IMM AND       CYC(2)  BREAK
      CASE(0x2A)       ROLA          CYC(2)  BREAK
      CASE(0x2C)       ABS BIT       CYC(4)  BREAK
      CASE(0x2D)       ABS AND       CYC(2)  BREAK
      CASE(0x2E)       ABS ROL       CYC(6)  BREAK
      CASE(0x30)       REL BMI       CYC(3)  BREAK
      CASE(0x31)       INDY AND      CYC(5)  BREAK
      CASE(0x38)       SEC           CYC(2)  BREAK
      CASE(0x39)       ABSY AND      CYC(4)  BREAK
      CASE(0x3D)       ABSX AND      CYC(4)  BREAK
      CASE(0x3E)       ABSX ROL      CYC(6)  BREAK
      CASE(0x41)       INDX EOR      CYC(6)  BREAK
      CASE(0x48)       PHA           CYC(3)  BREAK
      CASE(0x49)       IMM EOR       CYC(2)  BREAK
      CASE(0x4A)       LSRA          CYC(2)  BREAK
      CASE(0x4C)       ABS JMP       CYC(3)  BREAK
      CASE(0x4D)       ABS EOR       CYC(4)  BREAK
      CASE(0x4E)       ABS LSR       CYC(6)  BREAK
      CASE(0x50)       REL BVC       CYC(3)  BREAK
      CASE(0x51)       INDY EOR      CYC(5)  BREAK
      CASE(0x58)       CLI           CYC(2)  BREAK
      CASE(0x59)       ABSY EOR      CYC(4)  BREAK
      CASE(0x5D)       ABSX EOR      CYC(4)  BREAK
      CASE(0x5E)       ABSX LSR      CYC(6)  BREAK
      CASE(0x60)       RTS           CYC(6)  BREAK
      CASE(0x61)       INDX ADC      CYC(6)  BREAK
      CASE(0x68)       PLA           CYC(4)  BREAK
      CASE(0x69)       IMM ADC       CYC(2)  BREAK
      CASE(0x6A)       RORA          CYC(2)  BREAK
      CASE(0x6C)       IABS JMP      CYC(6)  BREAK
      CASE(0x6D)       ABS ADC       CYC(4)  BREAK
      CASE(0x6E)       ABS ROR       CYC(6)  BREAK
      CASE(0x70)       REL BVS       CYC(3)  BREAK
      CASE(0x71)       INDY ADC      CYC(5)  BREAK
      CASE(0x78)       SEI           CYC(2)  BREAK
      CASE(0x79)       ABSY ADC      CYC(4)  BREAK
      CASE(0x7D)       ABSX ADC      CYC(4)  BREAK
      CASE(0x7E)       ABSX ROR      CYC(6)  BREAK
      CASE(0x81)       INDX STA      CYC(6)  BREAK
      CASE(0x88)       DEY           CYC(2)  BREAK
      CASE(0x8A)       TXA           CYC(2)  BREAK
      CASE(0x8C)       ABS STY       CYC(4)  BREAK
      CASE(0x8D)       ABS STA       CYC(4)  BREAK
      CASE(0x8E)       ABS STX       CYC(4)  BREAK
      CASE(0x90)       REL BCC       CYC(3)  BREAK
      CASE(0x91)       INDY STA      CYC(6)  BREAK
      CASE(0x98)       TYA           CYC(2)  BREAK
      CASE(0x99)       ABSY STA      CYC(5)  BREAK
      CASE(0x9A)       TXS           CYC(2)  BREAK
      CASE(0x9D)       ABSX STA      CYC(5)  BREAK
      CASE(0xA0)       IMM LDY       CYC(2)  BREAK
      CASE(0xA1)       INDX LDA      CYC(6)  BREAK
      CASE(0xA2)       IMM LDX       CYC(2)  BREAK
      CASE(0xA8)       TAY           CYC(2)  BREAK
      CASE(0xA9)       IMM LDA       CYC(2)  BREAK
      CASE(0xAA)       TAX           CYC(2)  BREAK
      CASE(0xAC)       ABS LDY       CYC(4)  BREAK
      CASE(0xAD)       ABS LDA       CYC(4)  BREAK
      CASE(0xAE)       ABS LDX       CYC(4)  BREAK
      CASE(0xB0)       REL BCS       CYC(3)  BREAK
      CASE(0xB1)       INDY LDA      CYC(5)  BREAK
      CASE(0xB8)       CLV           CYC(2)  BREAK
      CASE(0xB9)       ABSY LDA      CYC(4)  BREAK
      CASE(0xBA)       TSX           CYC(2)  BREAK
      CASE(0xBC)       ABSX LDY      CYC(4)  BREAK
      CASE(0xBD)       ABSX LDA      CYC(4)  BREAK
      CASE(0xBE)       ABSY LDX      CYC(4)  BREAK
      CASE(0xC0)       IMM CPY       CYC(2)  BREAK
      CASE(0xC1)       INDX CMP      CYC(6)  BREAK
      CASE(0xC8)       INY           CYC(2)  BREAK
      CASE(0xC9)       IMM CMP       CYC(2)  BREAK
      CASE(0xCA)       DEX           CYC(2)  BREAK
      CASE(0xCC)       ABS CPY       CYC(4)  BREAK
      CASE(0xCD)       ABS CMP       CYC(4)  BREAK
      CASE(0xCE)       ABS DEC       CYC(5)  BREAK
      CASE(0xD0)       REL BNE       CYC(3)  BREAK
      CASE(0xD1)       INDY CMP      CYC(5)  BREAK
      CASE(0xD8)       CLD           CYC(2)  BREAK
      CASE(0xD9)       ABSY CMP      CYC(4)  BREAK
      CASE(0xDD)       ABSX CMP      CYC(4)  BREAK
      CASE(0xDE)       ABSX DEC      CYC(6)  BREAK
      CASE(0xE0)       IMM CPX       CYC(2)  BREAK
      CASE(0xE1)       INDX SBC      CYC(6)  BREAK
      CASE(0xE8)       INX           CYC(2)  BREAK
      CASE(0xE9)       IMM SBC       CYC(2)  BREAK
      CASE(0xEA)       NOP           CYC(2)  BREAK
      CASE(0xEC)       ABS CPX       CYC(4)  BREAK
      CASE(0xED)       ABS SBC       CYC(4)  BREAK
      CASE(0xEE)       ABS INC       CYC(6)  BREAK
      CASE(0xF0)       REL BEQ       CYC(3)  BREAK
      CASE(0xF1)       INDY SBC      CYC(5)  BREAK
      CASE(0xF8)       SED           CYC(2)  BREAK
      CASE(0xF9)       ABSY SBC      CYC(4)  BREAK
      CASE(0xFD)       ABSX SBC      CYC(4)  BREAK
      CASE(0xFE)       ABSX INC      CYC(6)  BREAK

	  // now, for the zero-page address modes...
#undef READ
#define READ (READZB(addr))
#undef WRITE
#define WRITE(a) WRITEZB(a)

      CASE(0x05)       ZPG ORA       CYC(3)  BREAK
      CASE(0x06)       ZPG ASL       CYC(5)  BREAK
      CASE(0x15)       ZPGX ORA      CYC(4)  BREAK
      CASE(0x16)       ZPGX ASL      CYC(6)  BREAK
      CASE(0x24)       ZPG BIT       CYC(3)  BREAK
      CASE(0x25)       ZPG AND       CYC(3)  BREAK
      CASE(0x26)       ZPG ROL       CYC(5)  BREAK
      CASE(0x35)       ZPGX AND      CYC(4)  BREAK
      CASE(0x36)       ZPGX ROL      CYC(6)  BREAK
      CASE(0x45)       ZPG EOR       CYC(3)  BREAK
      CASE(0x46)       ZPG LSR       CYC(5)  BREAK
      CASE(0x55)       ZPGX EOR      CYC(4)  BREAK
      CASE(0x56)       ZPGX LSR      CYC(6)  BREAK
      CASE(0x65)       ZPG ADC       CYC(3)  BREAK
      CASE(0x66)       ZPG ROR       CYC(5)  BREAK
      CASE(0x75)       ZPGX ADC      CYC(4)  BREAK
      CASE(0x76)       ZPGX ROR      CYC(6)  BREAK
      CASE(0x84)       ZPG STY       CYC(3)  BREAK
      CASE(0x85)       ZPG STA       CYC(3)  BREAK
      CASE(0x86)       ZPG STX       CYC(3)  BREAK
      CASE(0x94)       ZPGX STY      CYC(4)  BREAK
      CASE(0x95)       ZPGX STA      CYC(4)  BREAK
      CASE(0x96)       ZPGY STX      CYC(4)  BREAK
      CASE(0xA4)       ZPG LDY       CYC(3)  BREAK
      CASE(0xA5)       ZPG LDA       CYC(3)  BREAK
      CASE(0xA6)       ZPG LDX       CYC(3)  BREAK
      CASE(0xB4)       ZPGX LDY      CYC(4)  BREAK
      CASE(0xB5)       ZPGX LDA      CYC(4)  BREAK
      CASE(0xB6)       ZPGY LDX      CYC(4)  BREAK
      CASE(0xC4)       ZPG CPY       CYC(3)  BREAK
      CASE(0xC5)       ZPG CMP       CYC(3)  BREAK
      CASE(0xC6)       ZPG DEC       CYC(5)  BREAK
      CASE(0xD5)       ZPGX CMP      CYC(4)  BREAK
      CASE(0xD6)       ZPGX DEC      CYC(6)  BREAK
      CASE(0xE4)       ZPG CPX       CYC(3)  BREAK
      CASE(0xE5)       ZPG SBC       CYC(3)  BREAK
      CASE(0xE6)       ZPG INC       CYC(5)  BREAK
      CASE(0xF5)       ZPGX SBC      CYC(4)  BREAK
      CASE(0xF6)       ZPGX INC      CYC(6)  BREAK

	  // less-often used instructions go to the end
      CASE(0x00)       BRK           CYC(7)  BREAK
      CASE(0x40)       RTI           CYC(6)  BREAK
      CASE(0x04) CMOS  ZPG TSB       CYC(5)  BREAK
      CASE(0x14) CMOS  ZPG TRB       CYC(5)  BREAK
      CASE(0x34) CMOS  ZPGX BIT      CYC(4)  BREAK
      CASE(0x64) CMOS  ZPG STZ       CYC(3)  BREAK
      CASE(0x74) CMOS  ZPGX STZ      CYC(4)  BREAK
      CASE(0x0C) CMOS  ABS TSB       CYC(6)  BREAK
      CASE(0x12) CMOS  IZPG ORA      CYC(5)  BREAK
      CASE(0x1A) CMOS  INA           CYC(2)  BREAK
      CASE(0x1C) CMOS  ABS TRB       CYC(6)  BREAK
      CASE(0x32) CMOS  IZPG AND      CYC(5)  BREAK
      CASE(0x3A) CMOS  DEA           CYC(2)  BREAK
      CASE(0x3C) CMOS  ABSX BIT      CYC(4)  BREAK
      CASE(0x52) CMOS  IZPG EOR      CYC(5)  BREAK
      CASE(0x5A) CMOS  PHY           CYC(3)  BREAK
      CASE(0x72) CMOS  IZPG ADC      CYC(5)  BREAK
      CASE(0x7A) CMOS  PLY           CYC(4)  BREAK
      CASE(0x7C) CMOS  ABSIINDX JMP  CYC(6)  BREAK
      CASE(0x80) CMOS  REL BRA       CYC(3)  BREAK
      CASE(0x89) CMOS  IMM BITI      CYC(2)  BREAK
      CASE(0x92) CMOS  IZPG STA      CYC(5)  BREAK
      CASE(0x9C) CMOS  ABS STZ       CYC(4)  BREAK
      CASE(0x9E) CMOS  ABSX STZ      CYC(5)  BREAK
      CASE(0xB2) CMOS  IZPG LDA      CYC(5)  BREAK
      CASE(0xD2) CMOS  IZPG CMP      CYC(5)  BREAK
      CASE(0xDA) CMOS  PHX           CYC(3)  BREAK
      CASE(0xF2) CMOS  IZPG SBC      CYC(5)  BREAK
      CASE(0xFA) CMOS  PLX           CYC(4)  BREAK
      CASE(0x03)
      CASE(0x07)
      CASE(0x0B)
      CASE(0x0F)
      CASE(0x13)
      CASE(0x17)
      CASE(0x1B)
      CASE(0x1F)
      CASE(0x23)
      CASE(0x27)
      CASE(0x2B)
      CASE(0x2F)
      CASE(0x33)
      CASE(0x37)
      CASE(0x3B)
      CASE(0x3F)
      CASE(0x43)
      CASE(0x47)
      CASE(0x4B)
      CASE(0x4F)
      CASE(0x53)
      CASE(0x57)
      CASE(0x5B)
      CASE(0x5F)
      CASE(0x63)
      CASE(0x67)
      CASE(0x6B)
      CASE(0x6F)
      CASE(0x73)
      CASE(0x77)
      CASE(0x7B)
      CASE(0x7F)
      CASE(0x83)
      CASE(0x87)
      CASE(0x8B)
      CASE(0x8F)
      CASE(0x93)
      CASE(0x97)
      CASE(0x9B)
      CASE(0x9F)
      CASE(0xA3)
      CASE(0xA7)
      CASE(0xAB)
      CASE(0xAF)
      CASE(0xB3)
      CASE(0xB7)
      CASE(0xBB)
      CASE(0xBF)
      CASE(0xC3)
      CASE(0xC7)
      CASE(0xCB)
      CASE(0xCF)
      CASE(0xD3)
      CASE(0xD7)
      CASE(0xDB)
      CASE(0xDF)
      CASE(0xE3)
      CASE(0xE7)
      CASE(0xEB)
      CASE(0xEF)
      CASE(0xF3)
      CASE(0xF7)
      CASE(0xFB)
      CASE(0xFF)       INVALID1      CYC(1)  BREAK
      CASE(0x02)       INVALID2      CYC(2)  BREAK
      CASE(0x22)       INVALID2      CYC(2)  BREAK
      CASE(0x42)       INVALID2      CYC(2)  BREAK
      CASE(0x44)       INVALID2      CYC(3)  BREAK
      CASE(0x54)       INVALID2      CYC(4)  BREAK
      CASE(0x62)       INVALID2      CYC(2)  BREAK
      CASE(0x82)       INVALID2      CYC(2)  BREAK
      CASE(0xC2)       INVALID2      CYC(2)  BREAK
      CASE(0xD4)       INVALID2      CYC(4)  BREAK
      CASE(0xE2)       INVALID2      CYC(2)  BREAK
      CASE(0xF4)       INVALID2      CYC(4)  BREAK
      CASE(0x5C)       INVALID3      CYC(8)  BREAK
      CASE(0xDC)       INVALID3      CYC(4)  BREAK
      CASE(0xFC)       INVALID3      CYC(4)  BREAK
    }
  }
  
	state->A = A;
	state->X = X;
	state->Y = Y;
	state->S = S;
	state->P = P;
	state->PPC = PC;
	state->clock += totalcycles - cycles;
}

void execute6502(T6502State* state,
				 void* context,
				 int totalcycles)
{
	SAVE_REGS
	execute6502_x(state, context, totalcycles);
	RESTORE_REGS
}

